#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;
varying vec4 shadowCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;
in vec4 shadowCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;

float PCSS (vec4 coord);

void main()
{
	float shadow = mix(0.4, 1.0, PCSS(shadowCoord));
#ifdef GL_ES
	vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
	fragColor = vec4(tColor.rgb * shadow, tColor.a);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
